<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    // gli utenti di tipo autore non possono accedere a questa pagina
    if($_SESSION["geecomAdmin_ruolo"]=="autore") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    $datiBlog     = $geecomDb->leggiSingolaRiga("geec_blog",1);

    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
    
?>
<!doctype html>
<html lang="en"><head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Geecom CMS - impostazioni blog</title>
    <?php
        include "../include/cssBaseComponenti.php";
    ?>	  
  </head>
  <body>
    
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div class="row py-4">
                
                <?php 
                    if($status==200) {
                        echo"<div class=\"col-12\">
                               <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                   Impostazioni salvate
                                   <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                         <span aria-hidden=\"true\">&times;</span>
                                   </button>
                               </div>
                           </div>";
                    }
                ?>
                
                <!-- Colonna principale -->
                <div class="col-12">
                    <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item active">Blog</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-body">
                            <form name="formDatiBlog" class="form-horizontal" role="form" name="formDatiBlog" action="aggiornaDati.php" method="post" >
                                <div class="row">

                                    <div class="col-md-3 col-xl-2 form-group">
                                        <label class="d-block">Attiva paginazione</label>
                                        <input type="checkbox" class="js-switch" name="mostraPaginazione" value="si" <?php
                                            if($datiBlog["mostraPaginazione"]=="si") { // se il valore = si aggiunge la parola checked
                                              echo"CHECKED";
                                           }
                                        ?>>
                                    </div>

                                    <div class="col-md-3 col-xl-2 form-group">
                                        <label for="">Articoli per pagina</label>
                                        <input type="number" class="form-control" min="1" name="articoliPerPagina" value="<?php  echo $datiBlog["articoliPerPagina"]; ?>" step="1">										
                                    </div>
                                    <hr class="clearfix w-100">

                                    <div class="col-md-6 col-xl-4 form-group">
                                        <label class="d-block">Articolo in evidenza</label>
                                        <select class="selectpicker" name="idArticoloInEvidenza" data-live-search="true" data-size="5" data-width="100%">
                                            <option value="0">Ultimo articolo pubblicato</option>
                                            <option data-divider="true"></option>
                                            <?php
                                                $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo'";
                                                $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                while($tag = $risNomi->fetch_assoc()) {
                                                    if($datiBlog["idArticoloInEvidenza"]==$tag["id"]) {
                                                        echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                    }
                                                    else {
                                                        echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Seleziona qual è il primo articolo che deve essere mostrato</small>
                                    </div>
                                    
                                    <div class="col-md-6 col-xl-4 form-group">
                                        <label for="">Aspetto articolo in evidenza</label>
                                        <select class="form-control" name="articoloInEvidenza">
                                            <?php
                                                $arrayAspettiArticoloEvidenza = ["classico","classico, senza troncamento","titolo sovrapposto","Compatto","Compatto, 2 per riga"];
                                                foreach($arrayAspettiArticoloEvidenza as $aspettoArticolo) {
                                                    if($datiBlog["articoloInEvidenza"]==$aspettoArticolo) {
                                                        echo"<option value=\"$aspettoArticolo\" selected>".ucfirst($aspettoArticolo)."</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$aspettoArticolo\">".ucfirst($aspettoArticolo)."</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Il primo articolo può avere un aspetto diverso dagli altri</small>
                                    </div>

                                     <div class="col-md-6 col-xl-4 form-group">
                                        <label for="">Aspetto articoli successivi</label>
                                        <select class="form-control" name="articoliSuccessivi">
                                            <?php
                                                $arrayAspettiArticoloEvidenza = ["classico","classico, senza troncamento","titolo sovrapposto","Compatto","Compatto, 2 per riga"];
                                                foreach($arrayAspettiArticoloEvidenza as $aspettoArticolo) {
                                                    if($datiBlog["articoliSuccessivi"]==$aspettoArticolo) {
                                                        echo"<option value=\"$aspettoArticolo\" selected>".ucfirst($aspettoArticolo)."</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$aspettoArticolo\">".ucfirst($aspettoArticolo)."</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Aspetto degli articoli succesivi al primo</small>
                                    </div>

                                    <div class="col-md-6 col-xl-4 form-group">
                                        <label for="">Proporzioni immagine in evidenza</label>
                                        <select class="form-control" name="aspettoImmagineInEvidenzaArticolo">
                                            <?php
                                                $arrayAspettiImmagine = [""=>"Proporzioni libere","aspect-ratio-4-3"=>"4:3","aspect-ratio-16-9"=>"16:9","aspect-ratio-21-9"=>"21:9","aspect-ratio-1-1"=>"1:1","aspect-ratio-3-4"=>"3:4","aspect-ratio-9-16"=>"9:16"];
                                                foreach($arrayAspettiImmagine as $chiave=>$valore) {
                                                    if($datiBlog["aspettoImmagineInEvidenzaArticolo"]==$chiave) {
                                                        echo"<option value=\"$chiave\" selected>$valore</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$chiave\">$valore</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Rapporto di aspetto dell'immagine in evidenza nelle pagine di elenco</small>
                                    </div>

                                    <div class="col-md-6 col-xl-4 form-group">
                                        <label for="">Proporzioni prima immagine articolo</label>
                                        <select class="form-control" name="aspettoImmaginePaginaArticolo">
                                            <?php
                                                $arrayAspettiImmagine = [""=>"Proporzioni libere","aspect-ratio-4-3"=>"4:3","aspect-ratio-16-9"=>"16:9","aspect-ratio-21-9"=>"21:9","aspect-ratio-1-1"=>"1:1","aspect-ratio-3-4"=>"3:4","aspect-ratio-9-16"=>"9:16"];
                                                foreach($arrayAspettiImmagine as $chiave=>$valore) {
                                                    if($datiBlog["aspettoImmaginePaginaArticolo"]==$chiave) {
                                                        echo"<option value=\"$chiave\" selected>$valore</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$chiave\">$valore</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Rapporto di aspetto dell'immagine in evidenza all'interno dell'articolo</small>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-footer">
                            <button type="button" onclick="document.formDatiBlog.submit()" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div><!--/Colonna principale -->
            </div>
        </div>
    </main>
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
                
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../include/jsBaseComponenti.php";
    ?>
    </body>
</html>